#!/bin/sh

BASE_DIR=/usr/local/scripts
BASE_NAME="${0##*/}" 

if [ -z "$1" ]; then
  echo "$BASE_NAME Please specify an IP address"
  exit 1
fi

IP="$1"

# Source functions file
. ${BASE_DIR}/haproxy_functions.sh

for i in "$HA_CFGDIR"/haproxy-${IP}-*.cfg; do
  [ "$i" = "$HA_CFGDIR/haproxy-${IP}-*.cfg" ] && continue # no files
  PORT="${i##*-}"
  PORT="${PORT%.cfg}"
  _ha_restart $IP $PORT
done

